
from gurobipy import *

# Create a model
m = Model("Hostel_Rooms")

# Define variables
H = m.addVar(lb=0, vtype=GRB.INTEGER, name="Heated_Rooms")
U = m.addVar(lb=0, vtype=GRB.INTEGER, name="Unheated_Rooms")

# Objective function: Maximize profit
m.setObjective(50*H + 35*U, GRB.MAXIMIZE)

# Constraints
m.addConstr(H + U == 40, "Total_Rooms")
m.addConstr(H >= 15, "Min_Heated_Rooms")
m.addConstr(U >= 4*H, "Unheated_vs_Heated")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Heated Rooms: {H.x}")
    print(f"Unheated Rooms: {U.x}")
    print(f"Total Profit: ${50*H.x + 35*U.x:.2f}")
else:
    print("No optimal solution found")
