
import gurobi

def solve_hostel_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x = model.addVar(lb=0, name="heated_rooms")
    y = model.addVar(lb=0, name="unheated_rooms")

    # Objective function: Maximize profit
    model.setObjective(50 * x + 35 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 40, name="total_rooms")
    model.addConstr(x >= 15, name="min_heated_rooms")
    model.addConstr(y >= 4 * x, name="preference_unheated")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"Heated rooms: {x.varValue:.0f}")
        print(f"Unheated rooms: {y.varValue:.0f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_hostel_problem()
