
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("engineer_staffing")

    # Create variables
    x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="new_grad") # Allowing fractional engineers for LP
    y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="senior")   # Allowing fractional engineers for LP


    # Set objective
    m.setObjective(1000*x + 3000*y, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1000*x + 3000*y <= 100000, "wage_bill")
    m.addConstr(x + y >= 50, "min_engineers")
    m.addConstr(y >= 10, "min_senior")
    m.addConstr(y >= (1/3)*x, "senior_ratio")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Number of New Grad Engineers: {x.x}")
        print(f"Number of Senior Engineers: {y.x}")
        print(f"Minimum Weekly Wage Bill: ${m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
