
from gurobipy import *

# Create a model
m = Model("Engineering_Wage_Bill")

# Define variables
x = m.addVar(name='new_grad_engineers', vtype=GRB.INTEGER, lb=0)
y = m.addVar(name='senior_engineers', vtype=GRB.INTEGER, lb=0)

# Set the objective function to minimize the wage bill
m.setObjective(1000*x + 3000*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(1000*x + 3000*y <= 100000, name='wage_bill_constraint')
m.addConstr(x + y >= 50, name='total_engineers_constraint')
m.addConstr(y >= 10, name='senior_engineers_minimum')
m.addConstr(y >= (1/3)*x, name='senior_to_new_grad_ratio')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"New Grad Engineers: {x.x}")
    print(f"Senior Engineers: {y.x}")
    print(f"Wage Bill: ${1000*x.x + 3000*y.x}")
else:
    print("No optimal solution found.")
