
import gurobi

def solve_engineering_company_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="new_grad_engineers")  # Number of new grad engineers
    y = model.addVar(lb=0, name="senior_engineers")  # Number of senior engineers

    # Objective function: Minimize the total weekly wage bill
    model.setObjective(1000*x + 3000*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1000*x + 3000*y <= 100000, name="wage_bill_constraint")  # Weekly wage bill constraint
    model.addConstr(x + y >= 50, name="total_engineers_constraint")  # Minimum total engineers constraint
    model.addConstr(y >= 10, name="senior_engineers_min_constraint")  # Minimum senior engineers constraint
    model.addConstr(y >= (1/3)*x, name="senior_to_new_grad_ratio_constraint")  # Senior engineers proportion constraint

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"New Grad Engineers: {x.varValue}")
        print(f"Senior Engineers: {y.varValue}")
        print(f"Minimum Wage Bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_engineering_company_problem()
