
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("essential_oil_optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ylang_ylang_acres")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vanilla_acres")

# Set objective function
m.setObjective(150*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "land_availability")
m.addConstr(x >= 10, "min_ylang_ylang")
m.addConstr(y >= 20, "min_vanilla")
m.addConstr(x <= 2*y, "ylang_vanilla_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Ylang Ylang Acres: {x.x}")
    print(f"Vanilla Acres: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

