
from gurobipy import *

# Create a model
m = Model("Essential_Oil_Producer")

# Define the decision variables
Y = m.addVar(vtype=GRB.CONTINUOUS, name="Ylang_Ylang_Acres")
V = m.addVar(vtype=GRB.CONTINUOUS, name="Vanilla_Acres")

# Set the objective function to maximize profit
m.setObjective(150*Y + 100*V, GRB.MAXIMIZE)

# Add constraints
m.addConstr(Y >= 10, "Min_Ylang_Ylang")
m.addConstr(V >= 20, "Min_Vanilla")
m.addConstr(Y + V <= 100, "Total_Land")
m.addConstr(Y <= 2*V, "Ylang_to_Vanilla_Ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ylang Ylang Acres: {Y.x}")
    print(f"Vanilla Acres: {V.x}")
    print(f"Total Profit: ${150*Y.x + 100*V.x:.2f}")
else:
    print("No optimal solution found")
