
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    Y = model.addVar(lb=0, name="Ylang_Ylang")
    V = model.addVar(lb=0, name="Vanilla")

    # Set bounds based on problem description
    Y.lb = 10  # At least 10 acres of ylang ylang
    V.lb = 20  # At least 20 acres of vanilla

    # Objective function: Maximize profit
    model.setObjective(150 * Y + 100 * V, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(Y + V <= 100, name="Total_Acres")  # Total acres constraint
    model.addConstr(Y <= 2 * V, name="Ylang_Ylang_vs_Vanilla")  # Ylang ylang vs. vanilla constraint

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of Ylang Ylang: {Y.varValue}")
        print(f"Optimal acres of Vanilla: {V.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
