
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="squash")

# Set objective function
m.setObjective(700*x + 144*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 1000, "land")
m.addConstr(20*x + 23*y <= 1200, "tractor_time")
m.addConstr(10*x + 110*y <= 26400, "capital")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of potatoes")
    print(f"Plant {y.x:.2f} acres of squash")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

