
from gurobipy import *

# Create a model
m = Model("Farming_Optimization")

# Define decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes_acres")
y = m.addVar(vtype=GRB.CONTINUOUS, name="squash_acres")

# Set the objective function to maximize profit
m.setObjective(700*x + 144*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 23*y <= 1200, name="tractor_time")
m.addConstr(10*x + 110*y <= 26400, name="capital_available")
m.addConstr(x + y <= 1000, name="land_available")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Plant {x.x:.2f} acres of potatoes and {y.x:.2f} acres of squash.")
else:
    print("No optimal solution found. The problem might be infeasible.")

