
import gurobi

def solve_farming_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, name="Potatoes")
    S = model.addVar(lb=0, name="Squash")

    # Objective function: Maximize profit
    model.setObjective(700 * P + 144 * S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(P + S <= 1000, name="Land")
    model.addConstr(20 * P + 23 * S <= 1200, name="Tractor_Time")
    model.addConstr(10 * P + 110 * S <= 26400, name="Capital")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres for Potatoes: {P.varValue}")
        print(f"Optimal acres for Squash: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_farming_problem()
