
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
x = model.addVar(lb=0, name="croissants")
y = model.addVar(lb=0, name="ficelles")

# Set objective function
model.setObjective(4.5 * x + 3.5 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * x + 17 * y <= 350, "mixing_time")
model.addConstr(2 * x + y <= 45, "vanilla_extract")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Number of Croissants: {x.x:.2f}")
    print(f"Number of Ficelles: {y.x:.2f}")
else:
    print("Infeasible or unbounded solution.")

