
from gurobipy import *

# Create a new model
model = Model("Bakery_Problem")

# Define the decision variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="Croissants")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="Ficelles")

# Set the objective function
model.setObjective(4.5*x1 + 3.5*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*x1 + 17*x2 <= 350, "Mixing_Time")
model.addConstr(2*x1 + x2 <= 45, "Vanilla_Extract")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Croissants: {x1.x}")
    print(f"Ficelles: {x2.x}")
    print(f"Maximum Revenue: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
