
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x = model.addVar(lb=0, name="croissant")  # Number of croissants
y = model.addVar(lb=0, name="ficelle")    # Number of ficelles

# Objective function: Maximize revenue
model.setObjective(4.5 * x + 3.5 * y, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(12 * x + 17 * y <= 350, name="mixing_time")
model.addConstr(2 * x + y <= 45, name="vanilla_extract")

# Optimize the model
model.optimize()

# Print the status of the optimization
print("Optimization Status:", model.status)

# If the model is optimized successfully
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print("Croissants:", x.varValue)
    print("Ficelles:", y.varValue)
    print("Max Revenue: $", 4.5 * x.varValue + 3.5 * y.varValue)
else:
    print("The model is infeasible or unbounded.")
