
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(name="carrots", lb=0)  # Acres of carrots
y = m.addVar(name="beets", lb=0)  # Acres of beets

# Set objective function
m.setObjective(500*x + 400*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 30, "land_constraint")
m.addConstr(x >= 3, "min_carrots")
m.addConstr(y >= 5, "min_beets")
m.addConstr(y >= x, "beet_preference")
m.addConstr(y <= 2*x, "labor_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of carrots")
    print(f"Plant {y.x:.2f} acres of beets")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

