
from gurobipy import *

# Create a new model
m = Model("Farmer_Profit_Optimization")

# Decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="carrots_acres")
y = m.addVar(vtype=GRB.CONTINUOUS, name="beets_acres")

# Objective function: Maximize profit
m.setObjective(500*x + 400*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 30, "land_availability")
m.addConstr(x >= 3, "min_carrots")
m.addConstr(y >= 5, "min_beets")
m.addConstr(y <= 2*x, "labor_constraints")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrots acres: {x.x}")
    print(f"Beets acres: {y.x}")
    print(f"Total profit: ${500*x.x + 400*y.x}")
else:
    print("No optimal solution found")
