
import gurobi

def solve_farmer_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    C = m.addVar(lb=3, name="Carrots")  # Minimum 3 acres of carrots
    B = m.addVar(lb=5, name="Beets")    # Minimum 5 acres of beets

    # Objective function: Maximize profit
    m.setObjective(500*C + 400*B, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(C + B <= 30, name="Total_Acres")  # Total acres constraint
    m.addConstr(B <= 2*C, name="Beets_to_Carrots_Ratio")  # Beets to carrots ratio

    # Solve the model
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of carrots: {C.varValue}")
        print(f"Optimal acres of beets: {B.varValue}")
        print(f"Max Profit: {m.objVal}")
    else:
        print("The model is infeasible")

solve_farmer_problem()
