
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("beanbag_game")

    # Create variables
    r = m.addVar(vtype=gp.GRB.INTEGER, name="red_beanbags")
    b = m.addVar(vtype=gp.GRB.INTEGER, name="blue_beanbags")

    # Set objective
    m.setObjective(5*r + 8*b, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(r >= 3, "min_red")
    m.addConstr(b >= 2, "min_blue")
    m.addConstr(r <= 8, "max_red")
    m.addConstr(b <= 8, "max_blue")
    m.addConstr(r + b == 12, "total_beanbags")

    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal number of red beanbags: {r.x}")
        print(f"Optimal number of blue beanbags: {b.x}")
        print(f"Maximum points: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
