
from gurobipy import *

# Create a new model
m = Model("Bean_Bags_Optimization")

# Define variables
r = m.addVar(vtype=GRB.INTEGER, name="red_bean_bags", lb=3, ub=8)
b = m.addVar(vtype=GRB.INTEGER, name="blue_bean_bags", lb=2, ub=8)

# Set the objective function
m.setObjective(5*r + 8*b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(r + b == 12, "total_bean_bags")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red Bean Bags: {r.x}")
    print(f"Blue Bean Bags: {b.x}")
    print(f"Total Points: {5*r.x + 8*b.x}")
else:
    print("No optimal solution found")
