
import gurobi

def solve_bean_bag_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=3, ub=8, name="Red_Bean_Bags", vtype=gurobi.GRB.INTEGER)
    B = model.addVar(lb=2, ub=8, name="Blue_Bean_Bags", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 5R + 8B
    model.setObjective(5 * R + 8 * B, gurobi.GRB.MAXIMIZE)

    # Constraint: R + B = 12
    model.addConstr(R + B == 12, name="Total_Bean_Bags")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Red Bean Bags = {R.varValue}, Blue Bean Bags = {B.varValue}")
        print(f"Maximum points: {5 * R.varValue + 8 * B.varValue}")
    else:
        print("The model is infeasible.")

solve_bean_bag_problem()
