
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("wood_decor_optimization")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="display_shelves")
y = model.addVar(vtype=GRB.INTEGER, name="plant_stands")

# Set objective function
model.setObjective(55*x + 45*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(25*x + 20*y <= 350, "carving_constraint")
model.addConstr(20*x + 10*y <= 600, "polishing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of display shelves: {x.x}")
    print(f"Number of plant stands: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

