
from gurobipy import *

# Create a new model
m = Model("Wood_Artist_Problem")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="display_shelves")
y = m.addVar(vtype=GRB.INTEGER, name="plant_stands")

# Set the objective function: Maximize profit
m.setObjective(55*x + 45*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x + 20*y <= 350, "carving_time")
m.addConstr(20*x + 10*y <= 600, "polishing_time")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Display Shelves: {x.x}")
    print(f"Plant Stands: {y.x}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
