
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables as integers
    x = model.addVar(name="display_shelves", lb=0, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="plant_stands", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(55 * x + 45 * y, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(25 * x + 20 * y <= 350, name="carving_time_constraint")
    model.addConstr(20 * x + 10 * y <= 600, name="polishing_time_constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${55 * x.varValue + 45 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
