
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("BagelProduction")

# Create decision variables
E = model.addVar(lb=0, name="EastsideHours")
W = model.addVar(lb=0, name="WestsideHours")

# Set objective function
model.setObjective(300*E + 500*W, GRB.MINIMIZE)

# Add constraints
model.addConstr(100*E + 50*W >= 800, "EverythingBagels")
model.addConstr(80*E + 60*W >= 600, "BlueberryBagels")
model.addConstr(30*E + 100*W >= 1000, "RegularBagels")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Eastside Bakery Hours: {E.x}")
    print(f"Westside Bakery Hours: {W.x}")
    print(f"Total Cost: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

