
from gurobipy import *

# Create a new model
m = Model("Bagel_Production")

# Define the decision variables
x_e = m.addVar(lb=0, name="Eastside_Bakery_Hours")
x_w = m.addVar(lb=0, name="Westside_Bakery_Hours")

# Define the objective function
m.setObjective(300*x_e + 500*x_w, GRB.MINIMIZE)

# Define the constraints
m.addConstr(100*x_e + 50*x_w >= 800, name="Everything_Bagels_Constraint")
m.addConstr(80*x_e + 60*x_w >= 600, name="Blueberry_Bagels_Constraint")
m.addConstr(30*x_e + 100*x_w >= 1000, name="Regular_Bagels_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eastside Bakery Hours: {x_e.x}")
    print(f"Westside Bakery Hours: {x_w.x}")
    print(f"Total Cost: ${300*x_e.x + 500*x_w.x:.2f}")
else:
    print("No optimal solution found.")
