
import gurobi

def bagel_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x = model.addVar(name="Eastside_hours", lb=0, obj=300)  # Hours for Eastside bakery
    y = model.addVar(name="Westside_hours", lb=0, obj=500)  # Hours for Westside bakery

    # Constraints
    model.addConstr(x * 100 + y * 50 >= 800, name="Everything_bagels")  # Everything bagels constraint
    model.addConstr(x * 80 + y * 60 >= 600, name="Blueberry_bagels")  # Blueberry bagels constraint
    model.addConstr(x * 30 + y * 100 >= 1000, name="Regular_bagels")  # Regular bagels constraint

    # Solve the model
    model.optimize()

    # Output solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal solution found. Eastside bakery: {x.varValue} hours, Westside bakery: {y.varValue} hours")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
bagel_production_problem()
