
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("BlueOceanProduction")

# Create decision variables
x = model.addVar(lb=0, name="Gamma_hours")  # Hours plant Gamma operates
y = model.addVar(lb=0, name="Delta_hours")  # Hours plant Delta operates

# Set objective function
model.setObjective(35*x + 95*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(4*x + 6*y >= 90, "Asphalt_demand")
model.addConstr(3*x + 5*y >= 85, "Brick_demand")


# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Gamma Hours: {x.x:.2f}")
    print(f"Delta Hours: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

