
from gurobipy import *

# Create a new model
m = Model("Blue_Ocean_Production")

# Decision Variables
G = m.addVar(name='Gamma', vtype=GRB.CONTINUOUS, lb=0)  # Hours of operation for plant Gamma
D = m.addVar(name='Delta', vtype=GRB.CONTINUOUS, lb=0)   # Hours of operation for plant Delta

# Objective Function: Minimize the total cost of production
m.setObjective(35*G + 95*D, GRB.MINIMIZE)

# Constraints
m.addConstr(4*G + 6*D >= 90, name='Asphalt_Production')  # At least 90 units of asphalt must be produced
m.addConstr(3*G + 5*D >= 85, name='Bricks_Production')    # At least 85 units of bricks must be produced

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Hours for Gamma: {G.x}, Hours for Delta: {D.x}")
    print(f"Total Cost: ${35*G.x + 95*D.x:.2f}")
else:
    print("No optimal solution found")
