
import gurobi

def solve_production_planning():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x_gamma = model.addVar(name="Gamma_hours", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x_delta = model.addVar(name="Delta_hours", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(35 * x_gamma + 95 * x_delta, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x_gamma + 6 * x_delta >= 90, name="Asphalt_demand")
    model.addConstr(3 * x_gamma + 5 * x_delta >= 85, name="Bricks_demand")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Gamma hours: {x_gamma.varValue}")
        print(f"Delta hours: {x_delta.varValue}")
        print(f"Total Cost: {model.objVal}")
    else:
        print("The model is infeasible")

solve_production_planning()
