
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Farm_Optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="carrots") # Acres of carrots
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pumpkins") # Acres of pumpkins

# Set objective function
m.setObjective(80*x + 124*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 1500, "Land_Constraint")
m.addConstr(15*x + 20*y <= 1000, "Tractor_Constraint")
m.addConstr(12*x + 55*y <= 25000, "Capital_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of carrots")
    print(f"Plant {y.x:.2f} acres of pumpkins")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

