
from gurobipy import *

# Create a new model
m = Model("Frank_Farming")

# Define the variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="carrots", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="pumpkins", lb=0)

# Set the objective function
m.setObjective(80*x + 124*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 1500, "land")
m.addConstr(15*x + 20*y <= 1000, "tractor_time")
m.addConstr(12*x + 55*y <= 25000, "capital")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrots: {x.x} acres")
    print(f"Pumpkins: {y.x} acres")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")

