
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(name="carrots", lb=0)
    y = model.addVar(name="pumpkins", lb=0)

    # Objective function: Maximize profit
    model.setObjective(80*x + 124*y, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x + y <= 1500, name="land_constraint")
    model.addConstr(15*x + 20*y <= 1000, name="tractor_time_constraint")
    model.addConstr(12*x + 55*y <= 25000, name="capital_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of carrots: {x.varValue}")
        print(f"Optimal acres of pumpkins: {y.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible")

if __name__ == "__main__":
    solve_optimization_problem()
