
import gurobipy as gp

# Create a new model
m = gp.Model("CarTruckInventory")

# Create decision variables
c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cars")
t = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="trucks")

# Set objective function
m.setObjective(2000 * c + 4000 * t, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * c + 45 * t <= 450, "space")
m.addConstr(0.4 * c - 0.6 * t >= 0, "car_proportion")
m.addConstr(30000 * c + 40000 * t <= 800000, "budget")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Cars (c): {c.x}")
    print(f"Number of Trucks (t): {t.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

