
from gurobipy import *

# Create a new model
m = Model("Car_Truck_Stocking")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="cars")
y = m.addVar(vtype=GRB.INTEGER, name="trucks")

# Objective function: Maximize profit
m.setObjective(2000*x + 4000*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(30*x + 45*y <= 450, "space_constraint")
m.addConstr(30000*x + 40000*y <= 800000, "capital_constraint")
m.addConstr(x >= 1.5*y, "car_proportion_constraint")
m.addConstr(x >= 0, "non_negative_cars")
m.addConstr(y >= 0, "non_negative_trucks")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: ${2000*x.x + 4000*y.x:.2f}")
else:
    print("No optimal solution found.")
