
import gurobipy as gp

# Create a new model
model = gp.Model("CarDealership")

# Decision variables
x_c = model.addVar(name="cars", lb=0, vtype=gp.GRB.INTEGER)
x_t = model.addVar(name="trucks", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(2000*x_c + 4000*x_t, gp.GRB.MAXIMIZE)

# Space constraint
model.addConstr(30*x_c + 45*x_t <= 450, name="space")

# Capital constraint
model.addConstr(30000*x_c + 40000*x_t <= 800000, name="capital")

# Car proportion constraint
model.addConstr(x_c >= 1.5*x_t, name="car_proportion")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of cars: {x_c.varValue}")
    print(f"Optimal number of trucks: {x_t.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("The model is infeasible")
