
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("pot_optimization")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="x") # oval pots
y = model.addVar(vtype=GRB.CONTINUOUS, name="y") # square pots

# Set objective function
model.setObjective(4.5*x + 8*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(40*x + 35*y <= 2500, "shaping_constraint")
model.addConstr(50*x + 80*y <= 3800, "baking_constraint")
model.addConstr(x >= 0, "x_nonnegativity")
model.addConstr(y >= 0, "y_nonnegativity")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Oval Pots (x): {x.x}")
    print(f"Square Pots (y): {y.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

