
from gurobipy import *

# Create a model
m = Model("Terracotta_Pots")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Oval_Pots")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Square_Pots")

# Set the objective function (maximize profit)
m.setObjective(4.5*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40*x + 35*y <= 2500, "Shaping_Time")
m.addConstr(50*x + 80*y <= 3800, "Baking_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of oval pots: {x.x:.2f}")
    print(f"Optimal number of square pots: {y.x:.2f}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("The model is infeasible")
