
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="oval_pots", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="square_pots", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(4.5 * x + 8 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(40 * x + 35 * y <= 2500, name="shaping_time_constraint")
    model.addConstr(50 * x + 80 * y <= 3800, name="baking_time_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Oval pots: {x.varValue}, Square pots: {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_optimization_problem()
