
import gurobipy as gp

# Create a new model
model = gp.Model("AlmondMix")

# Create decision variables
x1 = model.addVar(lb=0, name="x1") # First mix (kg)
x2 = model.addVar(lb=0, name="x2") # Second mix (kg)

# Set objective function
model.setObjective(12*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.3*x1 + 0.4*x2 <= 100, "HoneyRoasted")
model.addConstr(0.7*x1 + 0.6*x2 <= 150, "ChocolateCovered")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"First mix (kg): {x1.x:.2f}")
    print(f"Second mix (kg): {x2.x:.2f}")
else:
    print("Infeasible or unbounded solution.")

