
from gurobipy import *

# Create a new model
m = Model("Honey_Roasted_Almonds_Optimization")

# Define the decision variables
x1 = m.addVar(name="First_Mix", lb=0)
x2 = m.addVar(name="Second_Mix", lb=0)

# Set the objective function: Maximize profit
m.setObjective(12*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.3*x1 + 0.4*x2 <= 100, name="Honey_Roasted_Almonds_Constraint")
m.addConstr(0.7*x1 + 0.6*x2 <= 150, name="Chocolate_Covered_Almonds_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"First Mix: {x1.x} kg")
    print(f"Second Mix: {x2.x} kg")
    print(f"Max Profit: ${12*x1.x + 15*x2.x}")
else:
    print("No optimal solution found")

