
import gurobi

def solve_almond_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(name="first_mix", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="second_mix", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(12 * x1 + 15 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.3 * x1 + 0.4 * x2 <= 100, name="honey_roasted_constraint")
    model.addConstr(0.7 * x1 + 0.6 * x2 <= 150, name="chocolate_covered_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. First mix: {x1.varValue} kg, Second mix: {x2.varValue} kg")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible or unbounded.")

# Run the function
solve_almond_mix_problem()
