
from gurobipy import *

# Create a new model
m = Model("Nolan_Contest")

# Define the variables
x = m.addVar(lb=15, ub=20, vtype=GRB.INTEGER, name="multiple_choice")
y = m.addVar(lb=10, ub=20, vtype=GRB.INTEGER, name="short_answer")

# Set the objective function
m.setObjective(2*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 30, "total_questions")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Multiple Choice Questions: {x.x}")
    print(f"Short Answer Questions: {y.x}")
    print(f"Total Score: {2*x.x + 5*y.x}")
else:
    print("No optimal solution found")
