
import gurobi

def nolan_contest():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, ub=20, name="multiple_choice")
    y = model.addVar(lb=0, ub=20, name="short_answer")

    # Objective function: maximize 2x + 5y
    model.setObjective(2*x + 5*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 30, name="total_questions")
    model.addConstr(x >= 15, name="min_multiple_choice")
    model.addConstr(y >= 10, name="min_short_answer")
    model.addConstr(x <= 20, name="max_multiple_choice")
    model.addConstr(y <= 20, name="max_short_answer")

    # Integrate and solve
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Objective: {model.objVal}")
        print(f"Multiple choice questions: {x.varValue}")
        print(f"Short answer questions: {y.varValue}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    nolan_contest()
