
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Car_Bus_Wash")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="cars")  # Number of cars
y = model.addVar(vtype=GRB.INTEGER, name="buses") # Number of buses

# Set objective function
model.setObjective(50*x + 75*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x + 50*y <= 5000, "watering_time")
model.addConstr(10*x + 20*y <= 1500, "soap_cost")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Cars to wash: {x.x}")
    print(f"  Buses to wash: {y.x}")
    print(f"  Maximum earnings: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

