
from gurobipy import *

# Create a new model
m = Model("Car_and_Bus_Washing")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="cars_washed")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="buses_washed")

# Define the objective function: Maximize earnings
m.setObjective(50*x + 75*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 50*y <= 5000, name="watering_time")
m.addConstr(10*x + 20*y <= 1500, name="soap_budget")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cars washed: {x.x}")
    print(f"Buses washed: {y.x}")
    print(f"Maximum earnings: ${50*x.x + 75*y.x}")
else:
    print("No optimal solution found")
