
import gurobi

def solve_washing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="cars")
    y = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="buses")

    # Define the objective function
    model.setObjective(50*x + 75*y, gurobi.GRB.MAXIMIZE)

    # Add the watering time constraint
    model.addConstr(30*x + 50*y <= 5000, name="watering_time")

    # Add the soap cost constraint
    model.addConstr(10*x + 20*y <= 1500, name="soap_cost")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: cars = {x.varValue}, buses = {y.varValue}")
        print(f"Maximum earnings: ${model.objVal:.2f}")
    else:
        print("The model is infeasible or unbounded.")

solve_washing_problem()
