
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("Investment_Problem")

    # Create variables
    x = m.addVar(lb=0, name="cigarette_investment")
    y = m.addVar(lb=0, name="tobacco_investment")

    # Set objective function
    m.setObjective(0.30*x + 0.45*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 5000, "total_investment")
    m.addConstr(x >= 0.40 * (x + y), "cigarette_proportion")
    m.addConstr(y >= 1000, "min_tobacco")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal investment in cigarettes: ${x.x:.2f}")
        print(f"Optimal investment in tobacco: ${y.x:.2f}")
        print(f"Optimal total profit: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
