
from gurobipy import *

# Create a new model
m = Model("Frank_Investment")

# Create variables
x_c = m.addVar(lb=0, name="cigarette_investment")
x_t = m.addVar(lb=0, name="tobacco_investment")

# Set the objective function
m.setObjective(0.30*x_c + 0.45*x_t, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_c + x_t <= 5000, "total_investment")
m.addConstr(1.5*x_c >= x_t, "cigarette_proportion")
m.addConstr(x_t >= 1000, "tobacco_minimum")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cigarette investment: {x_c.x}")
    print(f"Tobacco investment: {x_t.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
