
import gurobi

def frank_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="cigarette_investment", lb=0)
    y = model.addVar(name="tobacco_investment", lb=0)

    # Objective function: Maximize profit
    model.setObjective(0.30 * x + 0.45 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 5000, name="total_investment")
    model.addConstr(0.60 * x - 0.40 * y >= 0, name="cigarette_proportion")
    model.addConstr(y >= 1000, name="tobacco_min_investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in cigarette industry: $", x.varValue)
        print("Optimal investment in tobacco industry: $", y.varValue)
        print("Maximum profit: $", model.objVal)
    else:
        print("The problem is infeasible")

if __name__ == "__main__":
    frank_investment_problem()
