
import gurobi

def woodshop_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(lb=0, name="Chairs")
    N = model.addVar(lb=0, name="Nightstands")

    # Objective function: Maximize profit
    model.setObjective(300*C + 500*N, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*C + 5*N <= 30, name="John's_Time")
    model.addConstr(4*C + 4*N <= 40, name="William's_Time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Chairs = {C.varValue}, Nightstands = {N.varValue}")
        print(f"Max Profit: ${300*C.varValue + 500*N.varValue}")
    else:
        print("No optimal solution found.")

# Run the optimization
woodshop_optimization()
